﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using GE.Visualisation;
using GE.Physics.Shapes;
using GE.Physics;
using GE.Manager;
using Microsoft.Xna.Framework;

namespace GE.World.Entities
{
    class FloorTrapperEntity : EnemyEntity
    {
        /// <summary>
        /// Animation
        /// </summary>
        int _iIdAnimation;

        /// <summary>
        /// First edge
        /// </summary>
        Vector2 _v2EdgeLeft;

        /// <summary>
        /// Second edge
        /// </summary>
        Vector2 _v2EdgeRight;

        /// <summary>
        /// Slow Speed
        /// </summary>
        Vector2 _v2SlowSpeed;

        /// <summary>
        /// Speed when the player is on the same platform
        /// </summary>
        Vector2 _v2FastSpeed;

        /// <summary>
        /// Physic shape
        /// </summary>
        //DynamicShapeRectangle _shape;

        /// <summary>
        /// Moving direction
        /// </summary>
        int _iDirection;

        /// <summary>
        /// Current frame of the animation
        /// </summary>
        int _iAnimationCurrentFrame;

        /// <summary>
        /// Current time of the animation
        /// </summary>
        int _iAnimationCurrentTime;

        /// <summary>
        /// Id of the explosion animation
        /// </summary>
        int _iIdAnimationExplosion;

        /// <summary>
        /// The position offset to display the explosion
        /// </summary>
        Vector2 _v2AnimationExplosionOffsetPosition;

        #region Properties Editor
#if !GAME
        public static string EDITOR_TILESET { get { return "enemysheet.xml"; } }
        public static string EDITOR_SPRITE { get { return "floor_trapper_2"; } }
#endif
        public int SlowSpeed { set { _v2SlowSpeed = new Vector2(value, 0); } }
        public int FastSpeed { set { _v2FastSpeed = new Vector2(value, 0); } }
        public Vector2 EdgeLeft { set { _v2EdgeLeft = value; } }
        public Vector2 EdgeRight { set { _v2EdgeRight = value; } }

        #endregion

        /// <summary>
        /// Constructor
        /// </summary>
        public FloorTrapperEntity()
            :base()
        {
            _iIdAnimation = -1;
            _v2EdgeLeft = Vector2.Zero;
            _v2EdgeRight = Vector2.Zero;
            _v2SlowSpeed = Vector2.Zero;
            _v2FastSpeed = Vector2.Zero;
            _shape = Physics.Physics.Instance.createDynamicRectangle(0, 0, Vector2.Zero, this);
            _shape._bCollisionEnable = false;
            _iDirection = -1;
            _iAnimationCurrentFrame = -1;
            _iAnimationCurrentTime = -1;
            _iIdAnimationExplosion = -1;
            _v2AnimationExplosionOffsetPosition = Vector2.Zero;
        }

        /// <summary>
        /// Initialise the entity. Load all the data which are not loaded during the level loading.
        /// </summary>
        public override void init()
        {
            _iIdAnimation = Visu.Instance.getAnimationID("Floor_Trapper");
            _iIdAnimationExplosion = Visu.Instance.getAnimationID("Little_Explosion");

            int iIdTexture = Visu.Instance.getAnimation(_iIdAnimation).indexTexture;
            int iIdSprite = Visu.Instance.getAnimation(_iIdAnimation).idFirstSprite;
            int iWidth = Visu.Instance.getSpriteWidth(iIdTexture, iIdSprite);
            int iHeight = Visu.Instance.getSpriteHeight(iIdTexture, iIdSprite);

            _shape.resize(iWidth, iHeight);
            _shape._v2position = Position;
            _shape._iGroup = (int)ePhysicGroup.ePhysicEnemy;

            _v2AnimationExplosionOffsetPosition = new Vector2(iWidth / 2, 0);

            base.init();
        }

        /// <summary>
        /// Activator
        /// </summary>
        public override void activate()
        {
            _shape._bCollisionEnable = true;
            
            _bActive = true;
            _iDirection = -1;
        }        

        /// <summary>
        /// Update
        /// </summary>
        public override void update()
        {
            //check if the player is ont the same platform
            if (World.Instance.PlayerPosition.X >= _v2EdgeLeft.X && World.Instance.PlayerPosition.X <= _v2EdgeRight.X &&
                    Position.Y > World.Instance.PlayerPosition.Y && Position.Y < World.Instance.PlayerPosition.Y + 30)//player's height
            {
                _v2Position += _v2FastSpeed * _iDirection;
            }
            else
            {
                //move the enemy
                _v2Position += _v2SlowSpeed * _iDirection;
            }

            //check if the enemy is on an edge
            if (_iDirection < 0)
            {
                if (_v2Position.X <= _v2EdgeLeft.X)
                    _iDirection = 1;
            }
            else
            {
                if (_v2Position.X > _v2EdgeRight.X)
                    _iDirection = -1;
            }
            _shape._v2position = _v2Position;

            //check collision
            CollisionResult res = Physics.Physics.Instance.checkFirstRegisteredCollisionEx(_shape, (int)ePhysicGroup.ePhysicPlayer);
            if (res != null)
            {
                res.Entity.hurt(_iDamages);
                die();
            }
        }

        /// <summary>
        /// Render
        /// </summary>
        public override void render()
        {
            Visu.Instance.displayAnimation(_iIdAnimation, ScreenPosition, ref _iAnimationCurrentFrame, ref _iAnimationCurrentTime);
        }

        public override void die()
        {
            _shape._bCollisionEnable = false;
            _bActive = false;
            Manager.ExplosionManager.Instance.activate(_iIdAnimationExplosion, Position + _v2AnimationExplosionOffsetPosition);
        }

        //public override void hurt(int damages)
        //{
        //    die();
        //}
    }
}
